  
 
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VALIDA_CNPJ]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VALIDA_CNPJ]
GO

  
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
AUTOR:RAMAM
DATA: 20/04/2010
*/
CREATE FUNCTION [dbo].[VALIDA_CNPJ](@CNPJ VARCHAR(15))
RETURNS CHAR(1)
AS
/*
=======================================================================================
'Job.................: Executada pela rotina p_plug_Farma_tipoRegistro_seis
'Funo..............: 
'Objetivo............:  
'Tabelas.............: 
'Dt Modificao......: 12/01/2021
'Modificao.........: Tag #I001 Remover caracter especial de CPNJ.
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
BEGIN
DECLARE  @INDICE INT, @SOMA INT, @DIG1 INT, @DIG2 INT, @VAR1 INT, @VAR2 INT, @RESULTADO CHAR(1)
--Tag #I001
 set @CNPJ = replace (@CNPJ, '/','')
 set @CNPJ = replace (@CNPJ, '.','')
 set @CNPJ = replace (@CNPJ, '-','')
 
 
 
	IF  LEN(@CNPJ)<> 14
		RETURN 'N';
	IF @CNPJ ='00000000000000' 
		RETURN 'N'


    SET @SOMA = 0
    SET @INDICE = 1
    SET @RESULTADO = 'N'
    
    SET @VAR1 = 5 
    WHILE (@INDICE <= 4) 
		BEGIN

		  SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CNPJ,@INDICE,1)) * @VAR1
		  SET @INDICE = @INDICE + 1  
		  SET @VAR1 = @VAR1 - 1 
		END
  
    SET @VAR2 = 9
    WHILE (@INDICE <= 12) 
		BEGIN
		  SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CNPJ,@INDICE,1)) * @VAR2
		  SET @INDICE = @INDICE + 1
		  SET @VAR2 = @VAR2 - 1             
		END
	
	SET @DIG1 = (@soma % 11)

	IF @DIG1 < 2
		SET @DIG1 = 0;
	ELSE  
		SET @DIG1 = 11 - (@soma % 11);
 

    SET @INDICE = 1
    SET @SOMA = 0
    SET @VAR1 = 6 
    SET @RESULTADO = 'N'

    WHILE (@INDICE <= 5) 
		BEGIN
		  SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CNPJ,@INDICE,1)) * @VAR1
		  SET @INDICE = @INDICE + 1  
		  SET @VAR1 = @VAR1 - 1  
		END
 
    SET @VAR2 = 9

    WHILE (@INDICE <= 13) 
		BEGIN
		  SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CNPJ,@INDICE,1)) * @VAR2 
		  SET @INDICE = @INDICE + 1
		  SET @VAR2 = @VAR2 - 1             
		END
 
   SET @DIG2 = (@soma % 11) 
   IF @DIG2 < 2
       SET @DIG2 = 0;
   ELSE  
       SET @DIG2 = 11 - (@soma % 11);

    IF (@DIG1 = SUBSTRING(@CNPJ,LEN(@CNPJ)-1,1)) AND (@DIG2 = SUBSTRING(@CNPJ,LEN(@CNPJ),1))
		SET @RESULTADO = 'S'
    ELSE
		SET @RESULTADO = 'N'

	
	RETURN @RESULTADO
  END

GO


/****** Object:  UserDefinedFunction [dbo].[CPF_VALIDO]    Script Date: 01/13/2014 15:50:51 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CPF_VALIDO]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[CPF_VALIDO]
GO

 
/****** Object:  UserDefinedFunction [dbo].[CPF_VALIDO]    Script Date: 01/13/2014 15:50:51 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
  Criado por Pedro Alves em 18-08-2009 para validar cpf
  Para testar: SELECT DBO.CPF_VALIDO('16195473247')
*/
CREATE FUNCTION [dbo].[CPF_VALIDO](@CPF VARCHAR(11))
RETURNS CHAR(1)
AS
BEGIN
  IF @CPF NOT LIKE '[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]' RETURN 'N';
  DECLARE @INDICE INT,
          @SOMA INT,
          @DIG1 INT,
          @DIG2 INT,
          @CPF_TEMP VARCHAR(11),
          @DIGITOS_IGUAIS CHAR(1),
          @RESULTADO CHAR(1)
          
  SET @RESULTADO = 'N'

  /*
      Verificando se os digitos so iguais
      A Principio CPF com todos o nmeros iguais so Invlidos
      apesar de validar o Calculo do digito verificado
      EX: O CPF 00000000000  invlido, mas pelo calculo
      Validaria
  */

  SET @CPF_TEMP = SUBSTRING(@CPF,1,1)

  SET @INDICE = 1
  SET @DIGITOS_IGUAIS = 'S'

  WHILE (@INDICE <= 11)
  BEGIN
    IF SUBSTRING(@CPF,@INDICE,1) <> @CPF_TEMP
      SET @DIGITOS_IGUAIS = 'N'
    SET @INDICE = @INDICE + 1
  END;

  --Caso os digitos no sejo todos iguais Comeo o calculo do digitos
  IF @DIGITOS_IGUAIS = 'N'
  BEGIN
    --Clculo do 1 dgito
    SET @SOMA = 0
    SET @INDICE = 1
    WHILE (@INDICE <= 9)
    BEGIN
      SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CPF,@INDICE,1)) * (11 - @INDICE);
      SET @INDICE = @INDICE + 1
    END

    SET @DIG1 = 11 - (@SOMA % 11)

    IF @DIG1 > 9
      SET @DIG1 = 0;

    -- Clculo do 2 dgito }
    SET @SOMA = 0
    SET @INDICE = 1
    WHILE (@INDICE <= 10)
    BEGIN
      SET @Soma = @Soma + CONVERT(INT,SUBSTRING(@CPF,@INDICE,1)) * (12 - @INDICE);
      SET @INDICE = @INDICE + 1
    END

    SET @DIG2 = 11 - (@SOMA % 11)

    IF @DIG2 > 9
      SET @DIG2 = 0;

    -- Validando
    IF (@DIG1 = SUBSTRING(@CPF,LEN(@CPF)-1,1)) AND (@DIG2 = SUBSTRING(@CPF,LEN(@CPF),1))
      SET @RESULTADO = 'S'
    ELSE
      SET @RESULTADO = 'N'
  END
  RETURN @RESULTADO
END
GO



 
/****** Object:  UserDefinedFunction [dbo].[VALIDA_CPF_CNPJ]    Script Date: 01/13/2014 15:50:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VALIDA_CPF_CNPJ]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[VALIDA_CPF_CNPJ]
GO
 

/****** Object:  UserDefinedFunction [dbo].[VALIDA_CPF_CNPJ]    Script Date: 01/13/2014 15:50:14 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*  
AUTOR: RAMAM  
DATA: 20/04/2010  
*/  
  
CREATE FUNCTION [dbo].[VALIDA_CPF_CNPJ](@CNPJ VARCHAR(14))  
RETURNS CHAR(1)  
  
AS
BEGIN  
 DECLARE @RESULTADO CHAR(1)  
  
 SET @RESULTADO = (SELECT DBO.CPF_VALIDO (@CNPJ))  
  
 IF @RESULTADO  = 'N'  
	SET @RESULTADO = (SELECT DBO.VALIDA_CNPJ (@CNPJ))  
  
 IF @CNPJ ='00000000000'   
	SET @RESULTADO = 'N'
 IF @CNPJ ='11111111111'
	SET @RESULTADO = 'N'
 IF @CNPJ ='99999999999'
	SET @RESULTADO = 'N'
 

 IF @CNPJ ='00000000000000' 
	SET @RESULTADO = 'N'
  
 RETURN @RESULTADO   
END

GO


